import java.io.*;
import java.util.Vector;
import org.kxml.*;
import org.kxml.io.*;
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import javax.microedition.io.*;


public class testkXMLDOM extends MIDlet implements CommandListener {
  static final String URL = "http://j2me.netinnovations.fr/livre/news/news.xml";
  static final String TITLE = "Actualits";
  Vector descriptions = new Vector ();
  List newsList = new List (TITLE, Choice.IMPLICIT);
  TextBox textBox = new TextBox ("", "", 256, TextField.ANY);
  Display display;
  Command backCmd = new Command ("Retour", Command.BACK, 0);

  class ReadThread extends Thread {

    public void run () {
      try {
        HttpConnection httpConnection = (HttpConnection) Connector.open (URL);
        XmlReader parser = new XmlReader (new InputStreamReader (httpConnection.openInputStream ()));
        parser.relaxed = true;
        parser.skip ();
        parser.require (Xml.START_TAG, null, "backslash");
        while (parser.skip () != Xml.END_TAG) 
          readStory (parser);
          parser.require (Xml.END_TAG, null, "backslash");
          parser.skip ();
          parser.require (Xml.END_DOCUMENT, null, null);
        } catch (Exception e) {
          e.printStackTrace ();
          descriptions.addElement (e.toString ());
          newsList.append ("Error", null);		
        }
      }
	
    // Lit un article et l'ajoute  la liste

    void readStory (XmlReader parser) throws IOException {
      parser.require (Xml.START_TAG, null, "story");
      String title = null;
      String description = null;
      while (parser.skip () != Xml.END_TAG) {
        parser.require (Xml.START_TAG, null, null);
        String name = parser.getName ();
        parser.next ();
        String text = parser.readText ();
        if (name.equals ("title")) title = text;
        else if (name.equals ("description")) description = text;
        parser.require (Xml.END_TAG, null, name);
      }
      parser.require (Xml.END_TAG, null, "story");
      if (description != null && title != null) {
        descriptions.addElement (description);
        newsList.append (title, null);
      }
    }
  }

  public void startApp () {
    display = Display.getDisplay (this);
    display.setCurrent (newsList);
    newsList.setCommandListener (this);
    textBox.setCommandListener (this);
    textBox.addCommand (backCmd);
    new ReadThread ().start ();
  }

  public void pauseApp () {
  }

  public void commandAction (Command c, Displayable d) {
    if (c == List.SELECT_COMMAND) {
      String text = (String) descriptions.elementAt (newsList.getSelectedIndex ());
      if (textBox.getMaxSize () < text.length ())  textBox.setMaxSize (text.length ());
      textBox.setString (text);
      display.setCurrent (textBox);
    } else if (c == backCmd) display.setCurrent (newsList);
  }
 
  public void destroyApp (boolean really) {
  }
}
